/*******************************************************************************
 *
 *                  M E N U   W I D G E T S
 *
 *              Copyright A Levido 2013 - All Rights Reserved
 *
 ******************************************************************************/
#include "widgets.h"
#include "menu.h"
#include "graphics.h"
//#include "USB/usb_hal_pic32.h"



const struct {
    INT16 x1;
    INT16 y1;
    INT16 x2;
    INT16 y2;
} clkLocs[] = {
    { BTN_COL1, BTN_ROW1, BTN_COL1 + BTN_WIDTH, BTN_ROW2 + BTN_HEIGHT },
    { BTN_COL2, BTN_ROW1, BTN_COL2 + BTN_WIDTH, BTN_ROW2 + BTN_HEIGHT },
    { BTN_COL3, BTN_ROW1, BTN_COL3 + BTN_WIDTH, BTN_ROW2 + BTN_HEIGHT },
};

const struct {
    INT16 x1;
    INT16 y1;
    INT16 x2;
    INT16 y2;
} btnLocs[] = {
    { 0, 0, 0, 0 },
    { BTN_COL2, LINE2_TOP, BTN_COL2 + BTN_WIDTH, LINE2_TOP + LINE2_HEIGHT },
    { 0, 0, 0, 0 },
    { BTN_COL1, BTN_ROW1, BTN_COL1 + BTN_WIDTH, BTN_ROW1 + BTN_HEIGHT },
    { BTN_COL2, BTN_ROW1, BTN_COL2 + BTN_WIDTH, BTN_ROW1 + BTN_HEIGHT },
    { BTN_COL3, BTN_ROW1, BTN_COL3 + BTN_WIDTH, BTN_ROW1 + BTN_HEIGHT },
    { BTN_COL1, BTN_ROW2, BTN_COL1 + BTN_WIDTH, BTN_ROW2 + BTN_HEIGHT },
    { BTN_COL2, BTN_ROW2, BTN_COL2 + BTN_WIDTH, BTN_ROW2 + BTN_HEIGHT },
    { BTN_COL3, BTN_ROW2, BTN_COL3 + BTN_WIDTH, BTN_ROW2 + BTN_HEIGHT },
    { BTN_COL1, BTN_ROW3, BTN_COL1 + BTN_WIDTH, BTN_ROW3 + BTN_HEIGHT },
    { BTN_COL2, BTN_ROW3, BTN_COL2 + BTN_WIDTH, BTN_ROW3 + BTN_HEIGHT },
    { BTN_COL3, BTN_ROW3, BTN_COL3 + BTN_WIDTH, BTN_ROW3 + BTN_HEIGHT },
    { BTN_COL1, BTN_ROW4, BTN_COL1 + BTN_WIDTH, BTN_ROW4 + BTN_HEIGHT },
    { BTN_COL2, BTN_ROW4, BTN_COL2 + BTN_WIDTH, BTN_ROW4 + BTN_HEIGHT },
    { BTN_COL3, BTN_ROW4, BTN_COL3 + BTN_WIDTH, BTN_ROW4 + BTN_HEIGHT },
};

#define CLK  clkLocs[i]
#define BTN  btnLocs[i]

void processTouch(SCREEN* scr, UINT16 code, INT16 x, INT16 y)
{
    UINT8 i;
    BUTTON* btn;
    CLICKER* clk;

    if( scr->cur_clicker_drag ) {
        while( y > scr->cur_clicker_y + 10 ) {
            scr->cur_clicker_y += 10;
            if(scr->cur_clicker->dec)scr->cur_clicker->dec(code);
        }
        while( y < scr->cur_clicker_y - 10 ) {
            scr->cur_clicker_y -= 10;
            if(scr->cur_clicker->inc)scr->cur_clicker->inc(code);
        }
        return;
    }
    if( scr->slider[0] && scr->slider[0]->pressed ) {
        while( x > scr->slider[0]->press_x + scr->slider[0]->rate ) {
            scr->slider[0]->press_x += scr->slider[0]->rate;
            if(scr->slider[0]->inc)scr->slider[0]->inc(code);
        }
        while( x < scr->slider[0]->press_x - scr->slider[0]->rate ) {
            scr->slider[0]->press_x -= scr->slider[0]->rate;
            if(scr->slider[0]->dec)scr->slider[0]->dec(code);
        }
        return;
    }

    /* Buttons */
    for(i = 0; i < 15; i++){
        btn = scr->button[i];
        if(btn == NULL) { continue; }
        if((x < BTN.x1) || (x > BTN.x2)) { continue; }
        if((y < BTN.y1) || (y > BTN.y2)) { continue; }
        
        /* a hit */
        if(btn->inactive) { return; }

        if(btn->maxstate == 0){
                if(code == PRESS) {
                    btn->state = 0;
            }
        }
        else if(btn->maxstate == 1){
            if(code == PRESS){
                btn->state = btn->state == 0 ? 1 : 0;
            }
        }
        else {
           // if((code == PRESS) || (code == STILL_PRESS)){
                btn->state++;
                if(btn->state > btn->maxstate) { 
                    btn->state = 0;
                }
            //}
        }
        if(btn->fun) { btn->fun(btn->state); }
    }
    /* Clickers */
    for(i = 0; i < 3; i++){
        clk = scr->clicker[i];
        if(clk == NULL) { continue; }
        if((x < CLK.x1) || (x > CLK.x2)) { continue; }
        if((y < CLK.y1) || (y > CLK.y2)) { continue; }

        /* a hit */
        if(clk->inactive) { return; }
        if( !scr->cur_clicker ) {
            scr->cur_clicker = clk;
            scr->cur_clicker_x = x;
            scr->cur_clicker_y = y;
        } else if( code == STILL_PRESS && x >= 0 && y >= 0 ) {
            int delta = scr->cur_clicker_y - y;
            if( delta < -10 || delta > 10 ) {
                scr->cur_clicker_drag = TRUE;
/*
                if( delta > 0 )
                    scr->cur_clicker_y += 5;
                else
                    scr->cur_clicker_y -= 5;
*/
                processTouch(scr, code, x, y);
                return;
            }
        }
        if(y < (CLK.y1 + CLK.y2) / 2) {
            //if((code == PRESS) || (code == STILL_PRESS)){
                if(clk->inc)clk->inc(code);
            //}
        }
        else{
           // if((code == PRESS) || (code == STILL_PRESS)){
                if(clk->dec)clk->dec(code);
           // }
        }
    }

    if( scr->slider[0] && code == PRESS ) {
        if( x >= scr->slider[0]->x1 && x < scr->slider[0]->x2 &&
            y >= scr->slider[0]->y1 && y < scr->slider[0]->y2 ) {
            scr->slider[0]->pressed = TRUE;
            scr->slider[0]->press_x = x;
            scr->slider[0]->press_y = y;
//            doSkipForward(0);
        }
    }
}

void processRelease(SCREEN* scr) {
    scr->cur_clicker = 0;
    scr->cur_clicker_drag = FALSE;
    if( scr->slider[0] )
        scr->slider[0]->pressed = FALSE;
}

#define ICN_MGN              20
#define TXT_OFFS            6

void drawWidgets(SCREEN* scr)
{
    UINT16 col, tcol;
    UINT i;
    CLICKER* clk;
    BUTTON* btn;

    /* If we have to redraw from scratch */
    if(scr->redraw & REDRAW_ALL) {
        
        scr->redraw = 0xffffffff;
        grBlock(0, 0, 239, 319, SCREEN_BG);
    }
    /* Redraw title */
    if(scr->redraw & REDRAW_TITLE){
        if(scr->error){
            grBlock(3, 0, 236, 22, TITLE_BG_ERR);
            grText(119, 13, TITLE_TXT_ERR, TITLE_BG_ERR, font16, TRUE, scr->titleText);
            grLine(3, 23, 236, 23, LINE_ERR, THICK);
        }
        else{
            grBlock(3, 3, 236, 22, SCREEN_BG);
            grText(119, 13, TITLE_TXT, SCREEN_BG, font16, TRUE, scr->titleText);
            grLine(3, 23, 236, 23, LINE, THICK);
        }
    }
    /* Redraw text line 1*/
    if(scr->redraw & REDRAW_LINE1){
        if(scr->error) { col = TXT1_ERR; } else { col = TXT1; }
        grBlock(0, 24, 239, 53, SCREEN_BG);
        grText(119, 39, col, SCREEN_BG, font16, TRUE, scr->line1Text);
    }
    /* Redraw Line 2*/
    if((scr->redraw & REDRAW_LINE2) && (scr->error == FALSE)){
        grBlock(0, 54, 239, 83, SCREEN_BG);
        grText(119, 69, TXT1, SCREEN_BG, font16, TRUE, scr->line2Text);
    }
    /* Redraw time & Date */
    if(scr->redraw & REDRAW_TIME){
        //grBlock(3, 300, 236, 319, SCREEN_BG);
        grText(3, 304, TIME, SCREEN_BG, font12, FALSE, scr->time);
        grText(100, 304, BATT, SCREEN_BG, font12, FALSE, scr->batt);
        grText(160, 304, DATE, SCREEN_BG, font12, FALSE, scr->date);
    }
    /* Redraw Clickers */
    for(i = 0; i < 3; i++){
        clk = scr->clicker[i];
        if(clk){
            if((clk->redraw) || (scr->redraw & REDRAW_ALL)){
                if(clk->inactive){ col = GRAYED; tcol = GRAYED_TXT;} else {col = clk->colour; tcol = NORMAL_TXT; }
                grFilledRoundRect(CLK.x1, CLK.y1, CLK.x2, CLK.y2, RAD, col);
                grText((CLK.x1 + CLK.x2) / 2, (CLK.y1 + CLK.y2) / 2 + 3, tcol, col, font12, TRUE, clk->text);
                grIcon((CLK.x1 + CLK.x2) / 2, CLK.y1 + ICN_MGN, tcol, col, clk->iconUp);
                grIcon((CLK.x1 + CLK.x2) / 2, CLK.y2 - ICN_MGN, tcol, col, clk->iconDn);
                clk->redraw = FALSE;
                clk->update = FALSE;
            }
            else if(clk->update){
                if(clk->inactive){ col = GRAYED; tcol = GRAYED_TXT;} else {col = clk->colour; tcol = NORMAL_TXT;}
                grBlock(CLK.x1 , (CLK.y1 + CLK.y2) / 2 - TXT_OFFS, CLK.x2 , (CLK.y1 + CLK.y2) / 2 + TXT_OFFS, col);
                grText((CLK.x1 + CLK.x2) / 2, (CLK.y1 + CLK.y2) / 2 + 3, tcol, col, font12, TRUE, clk->text);
                clk->update = FALSE;
            }
        }
    }

    /* Redraw Buttons */
    for( i = 0; i < 15; i++){
        btn = scr->button[i];
        if(btn){
            if((btn->redraw) || (scr->redraw & REDRAW_ALL)){
                if(btn->inactive){ col = GRAYED; tcol = GRAYED_TXT;} else {col = btn->colour; tcol = NORMAL_TXT; }
                grFilledRoundRect(BTN.x1, BTN.y1, BTN.x2, BTN.y2, RAD, col);
                if(btn->icon){
                    grIcon((BTN.x1 + BTN.x2) / 2 , (BTN.y1 + BTN.y2) / 2 , tcol, col, btn->icon);
                }
                else {
                    grText((BTN.x1 + BTN.x2) / 2 + 2, (BTN.y1 + BTN.y2) / 2 + 3, tcol, col, font16, TRUE, btn->text);
                }
                btn->redraw = FALSE;
            }
        }
    }
    
    scr->redraw = 0;
}